/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.base.Strings;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.planning.mokos.Scheduler;
import cz.insophy.inplan.planning.mokos.Util;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.util.Tuple;
import java.util.List;
import java.util.Set;

public class SameWorkplaceBoundUpdater
extends Processor {
    private PropertyDefinition sameWpSuccPd;
    private ShopConfiguration conf;

    @Override
    public void setScheduler(Scheduler scheduler) {
        super.setScheduler(scheduler);
        this.conf = scheduler.getSuperplan().getShopConf();
        this.sameWpSuccPd = this.conf.getPropertyDefinition(Action.class, "sameWpSucc");
    }

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        return Tuple.create(this.getDefaultSuccessor(), ops);
    }

    @Override
    public void onOperationPlanned(Operation op) {
        if (this.sameWpSuccPd == null) {
            return;
        }
        String succActionName = (String)op.getAction().getProperty(this.sameWpSuccPd);
        if (Strings.isNullOrEmpty(succActionName)) {
            return;
        }
        Operation sameWpOp = SameWorkplaceBoundUpdater.findSuccessorByName(op, succActionName);
        if (sameWpOp == null) {
            return;
        }
        Set<Workplace> usedWps = Util.getUsedWorkplaces(op.getPlannings().get(0));
        List<Workplace> possibleWps = this.conf.getWorkplaces(sameWpOp.getAction().getCapabilityReq());
        for (Workplace wp : possibleWps) {
            if (usedWps.contains(wp)) continue;
            sameWpOp.getBounds().updateCompositeBound(this, wp, Long.MAX_VALUE);
        }
    }

    private static Operation findSuccessorByName(Operation start, String actionName) {
        Set<Operation> successors = start.getSuccessors();
        for (Operation successor : successors) {
            if (successor.getGar().getParent() != start.getGar().getParent()) continue;
            if (successor.getAction().getName().equals(actionName)) {
                return successor;
            }
            Operation res = SameWorkplaceBoundUpdater.findSuccessorByName(successor, actionName);
            if (res == null) continue;
            return res;
        }
        return null;
    }
}

